(function($){
	
	$.fn.slickGallery = function(param){
		var element = this;
		
		var settings = $.extend({
			rpp			: 10,
			page		: 1,
			albumid		: 0,
			imgWidth	: 80,
			imgHeight	: 60
		},param);
		
		if(!settings.url)
			throw "You must provide a valid URL of your SlickGalley!";

		if(settings.url.charAt(settings.url.length-1) != '/') settings.url+='/';
		
		var imageSize = 'imgSmall';
		if(settings.imgWidth > 160) imageSize = 'imgMid';

		$.getJSON(
			settings.url+'assets/api/?callback=?',
			{
				"rpp"		: settings.rpp,
				"page"		: settings.page,
				"albumid"	: settings.albumid
			},
			function(msg){

				if($.isFunction(settings.callback))
				{
					settings.callback(msg);
					return true;
				}

				if(!msg || !msg.pics || !msg.pics.length) return false;
				
				var pic;
				for(var i=0,z=msg.pics.length;i<z;i++)
				{
					pic = msg.pics[i];
					element.append(
						'<a href="'+settings.url+'#'+pic.href+'" target="_blank" title="'+pic.title+'">'+
						'<img src="'+settings.url+pic[imageSize]+'" width="'+settings.imgWidth+'" height="'+settings.imgHeight+'" />'+
						'</a>'
					);

				}
			}
		);
		return this;
	};
	
})(jQuery);